%three_suns

function three_suns

addpath('functions','-begin')

vmax = 10;
AUmax = 8;
view_option = 3;

%Compute initial orbital parameters for the two stars such that they rotate
%in a circular fashion about their mutual centre of mass

%Star masses in Solar masses
M1 = 1;
M2 = M1;
M3 = 0.1*M1;

%Gravity sim title
title_str = ['M1 = ',num2str(M1),', M2 = ',num2str(M2),', M3 = ',num2str(M3) ];

%Star separation /AU
s = 5;

%Compute two star orbital parameters
[vx1,vx2,vy1,vy2,vz1,vz2,x1,y1,z1,x2,y2,z2,xx,yy,zz] =...
    two_body_circular_init( M1, M2, s );

%Star 1
masses(1).name = 'Sun';
masses(1).mass = M1;
masses(1).radii = 0.01;
masses(1).x0 = x1;
masses(1).y0 = y1;
masses(1).z0 = z1;
masses(1).vx0 = vx1;
masses(1).vy0 = vz1;
masses(1).vz0 = vy1;
masses(1).marker_RGB = [];

%Star 2
masses(2).name = 'Planet X';
masses(2).mass = M2;
masses(2).radii = 0.001;
masses(2).x0 = x2;
masses(2).y0 = y2;
masses(2).z0 = z2;
masses(2).vx0 = vx2;
masses(2).vy0 = vz2;
masses(2).vz0 = vy2;
masses(2).marker_RGB = [];

%Star 3
masses(3).name = 'Planet Y';
masses(3).mass = M3;
masses(3).radii = 0.001;
masses(3).x0 = 10;
masses(3).y0 = 0;
masses(3).z0 = 0;
masses(3).vx0 = -2;
masses(3).vy0 = -0.1;
masses(3).vz0 = 0;
masses(3).marker_RGB = [0,0,0];

%Rings and clusters of massless objects initially rotating about the two stars

%Ring 1
rings(1).xc = x1;
rings(1).yc = y1;
rings(1).zc = z1;
rings(1).vxc = vx1;
rings(1).vyc = vy1;
rings(1).vzc = vz1;
rings(1).num_rings = 15;
rings(1).arc_separation_AU = 2*pi/30;
rings(1).first_ring_radius_AU = 1;
rings(1).ring_radius_diff_AU = 0.2;
rings(1).mass_at_centre = M1;
rings(1).marker_RGB = [1,0,0];

%Ring 2
rings(2).xc = x2;
rings(2).yc = y2;
rings(2).zc = z2;
rings(2).vxc = vx2;
rings(2).vyc = vy2;
rings(2).vzc = vz2;
rings(2).num_rings = 15;
rings(2).arc_separation_AU = 2*pi/30;
rings(2).first_ring_radius_AU = 1;
rings(2).ring_radius_diff_AU = 0.2;
rings(2).mass_at_centre = M2;
rings(2).marker_RGB = [0,0,1];

%Clusters
clusters = [];

%Run simulation
gravity_sim( masses, rings, clusters, view_option, AUmax, vmax, title_str )

rmpath('functions')

%End of code

