function collide_test

%Mass 1 BEFORE
m1 = 1
ux1 = -1
uy1 = 0
uz1 = 0

%Mass 2 BEFORE
m2 = 1
ux2 = 1
uy2 = 0
uz2 = 0

%Coefficient of restitution
C = 1;

%Compute velocities AFTER collision
[vx1,vy1,vz1,...
    vx2,vy2,vz2,...
    vmax,...
    KE1_pre,KE1_post,...
    KE2_pre,KE2_post,...
    KE_tot_pre,KE_tot_post] = collide( ux1,uy1,uz1, ux2,uy2,uz2, m1, m2, C )

%Plot BEFORE and AFTER diagrams
msize = 2;
qsize = 4;
limits = 2.2*[-vmax,vmax ];
figure('name','collision test','color',[1 1 1])
view2or3 = 2;

%BEFORE
subplot(1,2,1);
axis vis3d
set(gca,'DataAspectRatioMode','manual',...
    'xlim',limits,'ylim',limits,'zlim',limits,'nextplot','add')
grid on
if view2or3~=2; view([-30,42]); else view(2); end;
plot3( 0,0,0, 'ro','markerfacecolor','r','markersize',msize*m1 );
q1 = quiver3( 0,0,0, ux1,uy1,uz1, 'r');
adjust_quiver_arrowhead_size(q1, qsize);
plot3( vmax,0,0, 'bo','markerfacecolor','b','markersize',msize*m2 );
q2 = quiver3( vmax,0,0, ux2,uy2,uz2, 'b'); adjust_quiver_arrowhead_size(q2, qsize);
title(['BEFORE: KE = ',num2str(KE_tot_pre),'J'])
xlabel('x'); ylabel('y'); zlabel('z')
zoom(0.8)

%AFTER
subplot(1,2,2);
axis vis3d
set(gca,'DataAspectRatioMode','manual',...
    'xlim',limits,'ylim',limits,'zlim',limits,'nextplot','add')
grid on
if view2or3~=2; view([-30,42]); else view(2); end;
plot3( 0,0,0, 'ro','markerfacecolor','r','markersize',msize*m1 );
hold on; axis manual
q1 = quiver3( 0,0,0, vx1,vy1,vz1, 'r'); adjust_quiver_arrowhead_size(q1, qsize);
if C==0
    plot3( vmax/10,0,0, 'bo','markerfacecolor','b','markersize',msize*m2 );
    q2 = quiver3( vmax/10,0,0, vx2,vy2,vz2, 'b'); 
else
    plot3( vmax,0,0, 'bo','markerfacecolor','b','markersize',msize*m2 );
    q2 = quiver3( vmax,0,0, vx2,vy2,vz2, 'b'); 
end
adjust_quiver_arrowhead_size(q2, qsize);
title(['AFTER : KE = ',num2str(KE_tot_post),'J'])
xlabel('x'); ylabel('y'); zlabel('z')
zoom(0.8)

%Print figure as a PNG file
print( gcf, '-dpng','-r300','Collision test' )

%End of code