%aristarchus
% Construction of Aristarchus of Samos's diagram for computing the
% Astronomical Unit (AU), i.e. the Earth Sun distance, from the timings
% between a full and new moon.
%
% LAST UPDATED by Dr Andy French. September 2025.

function aristarchus

%Earth-Moon distance in AU (NOT TO SCALE!)
a = 0.3;  

%Angles in radians of a full circle
theta = linspace(0,2*pi,1000); 

%Plot Earth's orbit
plot( cos(theta), sin(theta), 'k--','linewidth',2 );
axis equal; hold on;

%Plot lunar orbit (not to scale)
plot( a*cos(theta), 1+a*sin(theta), 'b--','linewidth',2 );

%Polar angle of new Moon position and x,y coordinates
phi = asin(a); xnm = a*cos(phi);  ynm = 1-a*sin(phi);

%Plot triangle between Sun, Earth and Half Moon
plot( [0,xnm, 0,0],[0,ynm,1,0],'r-','linewidth',2);
axis off;

%Plot PNG and close
print(gcf,'aristarchus.png','-dpng','-r300');

%End of code