%Solar System
%Two suns with equal mass. Each is surrounded by concentric rings which
%co-rotate with the circular orbit of the masses.

%Astronomical parameters in SI units
AU = 149.6e9;
G = 6.67e-11;
M_sun = 2e30;
Yr = 365*24*3600;

%Dimensionless number which controls the dynamics, and results from the
%scaling of mass, distance and time parameters to make them dimensionless.
P = G*Yr^2*M_sun/(AU^3);

%Strength of gravity
G_factor = 1;
P = G_factor*P;

%Scale the solar mass
M_Sun = 1;

%Set dimensions of space
AUmax = 8;

%Initial star separation /AU
s = 4;

%Boundary coefficient of restitution (if [] then there is
%no boundary)
k = [];

%Initial view option
view_option = 2;

%For 2D views, choose density or speed map underlay ('density', 'speed',
%'none')
map_underlay = 'none';

%Sun (the position of this one can be modified)
masses(1).name = 'Sun';
masses(1).mass = M_Sun;
masses(1).radii = 0.1;
masses(1).x0 = 0;
masses(1).y0 = 0;
masses(1).z0 = 0;
masses(1).vx0 = 0;
masses(1).vy0 = 0;
masses(1).vz0 = 0;
masses(1).marker_RGB = [1,0,0];
masses(1).marker_size = 10;

%Define masses of planets in Earth masses
M = [
    0.0553,...  %Mercury
    0.815,...   %Venus
    1.0,...     %Earth
    0.107,...   %Mars
    317.83,...  %Jupiter
    95.159,...  %Saturn
    14.536,...  %Uranus
    17.147      %Neptune
    ];
%Convert to solar masses
M = M/332837;

%Distance (separation) of planets away from the sun in AU
S = [
    0.383,...   %Mercury
    0.627,...   %Venus
    1.0,...     %Earth
    1.279,...   %Mars
    3.487,...   %Jupiter
    8.854,...   %Saturn
    19.523,...  %Uranus
    29.864      %Neptune
    ];

%Define a vector of planet masses
for n = 1:length(M)
    
    %Binary star circular orbit conditions
    [vx1,vx2,vy1,vy2,vz1,vz2,x1,y1,z1,x2,y2,z2,xx,yy,zz] =...
        two_body_circular_init( M_Sun, M(n), S(n), P );
    
    %Sun (the position of this one can be modified)
    masses(n+1).name = 'Sun #2';
    masses(n+1).mass = M(n);
    masses(n+1).radii = 0.1;
    masses(n+1).x0 = x2;
    masses(n+1).y0 = y2;
    masses(n+1).z0 = z2;
    masses(n+1).vx0 = vx2;
    masses(n+1).vy0 = vy2;
    masses(n+1).vz0 = vz2;
    masses(n+1).marker_RGB = [0,0,1];
    masses(n+1).marker_size = 5;
end

%Rings
rings = [];

%Clusters
clusters = [];

%End of code