%Gravity sim default inputs

%Astronomical parameters in SI units
AU = 149.6e9;
G = 6.67e-11;
M_sun = 2e30;
Yr = 365*24*3600;

%Dimensionless number which controls the dynamics, and results from the
%scaling of mass, distance and time parameters to make them dimensionless.
P = G*Yr^2*M_sun/(AU^3);

%Strength of gravity
G_factor = 1;
P = G_factor*P;

%Set dimensions of space
AUmax = 8;

%Star masses in Solar masses
M1 = 1;
M2 = 1;

%Initial star separation /AU
s = 4;

%Boundary coefficient of restitution (if [] then there is
%no boundary)
k = 0.8;

%Initial view option
view_option = 2;

%For 2D views, choose density or speed map underlay ('density', 'speed',
%'none')
map_underlay = 'density';

%Binary star circular orbit conditions
[vx1,vx2,vy1,vy2,vz1,vz2,x1,y1,z1,x2,y2,z2,xx,yy,zz] =...
    two_body_circular_init( M1, M2, s, P );

%Star (the position of this one can be modified)
masses(1).name = 'Sun #1';
masses(1).mass = M1;
masses(1).radii = 0.1;
masses(1).x0 = x1;
masses(1).y0 = y1;
masses(1).z0 = z1;
masses(1).vx0 = vx1;
masses(1).vy0 = vz1;
masses(1).vz0 = vy1;
masses(1).marker_RGB = [];
masses(1).marker_size = 5;

%Star (the position of this one can be modified)
masses(2).name = 'Sun #2';
masses(2).mass = M1;
masses(2).radii = 0.1;
masses(2).x0 = x2;
masses(2).y0 = y2;
masses(2).z0 = z2;
masses(2).vx0 = vx2;
masses(2).vy0 = vz2;
masses(2).vz0 = vy2;
masses(2).marker_RGB = [];
masses(2).marker_size = 5;

%Rings (1)
rings(1).xc = x1;
rings(1).yc = y1;
rings(1).zc = z1;
rings(1).vxc = vx1;
rings(1).vyc = vy1;
rings(1).vzc = vz1;
rings(1).num_rings = 30;
rings(1).arc_separation_AU = 1*pi/30;
rings(1).first_ring_radius_AU = 1;
rings(1).ring_radius_diff_AU = 0.1;
rings(1).mass_at_centre = M1;
rings(1).marker_RGB = [0,0,0];

%Rings (2)
rings(2).xc = x2;
rings(2).yc = y2;
rings(2).zc = z2;
rings(2).vxc = vx2;
rings(2).vyc = vy2;
rings(2).vzc = vz2;
rings(2).num_rings = 30;
rings(2).arc_separation_AU = 1*pi/30;
rings(2).first_ring_radius_AU = 1;
rings(2).ring_radius_diff_AU = 0.1;
rings(2).mass_at_centre = M1;
rings(2).marker_RGB = [1,0,1];

%Clusters
clusters(1).xc = masses(2).x0;
clusters(1).yc = masses(2).y0;
clusters(1).zc = masses(2).z0;
clusters(1).vxc = masses(2).vx0;
clusters(1).vyc = masses(2).vy0;
clusters(1).vzc = masses(2).vz0;
clusters(1).shell_separation_AU = 0.2;
clusters(1).num_shells = 10;
clusters(1).num_masses_per_square_AU = 5;
clusters(1).first_shell_radius = 1;
clusters(1).mass_at_centre = M1;
clusters(1).marker_RGB = [1,0,1];

%End of code